### 概述

SF1011是一个能够对文件夹和文件进行开、关、读、写等操作的异步文件组件，通过该组件可以对工智机内的文件夹和文件执行一系列的操作。

下表概述了各个产品组件

| **产品组件**                            | **描述说明**      |
| ----------------------------------- | ------------- |
| cmpsysfile\_0.0.1-rc.3\_amd64.deb   | 异步文件的ACP客户端组件 |
| asyncfile-service\_0.0.3\_amd64.deb | 异步文件的ACP服务端组件 |
| SysFilePLC.library                  | PLC工程库文件      |
| SysFileLib.project                  | PLC快速启动工程     |
| Sinsegye.Ide.DeviceManager\_0.0.1.9 | 工智机设备管理系统     |

---
### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 个人电脑安装中科时代IDE MetaFacture软件；

* 工智机设备管理系统Sinsegye.Ide.DeviceManager

**安装过程**

**1、安装异步文件的ACP客户端、服务端和ACP服务组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）
```shell
sudo dpkg -i cmpsysfile\_0.0.1-rc.3\_amd64.deb&#xA;sudo dpkg -i asyncfile-service\_0.0.3\_amd64.deb&#xA;sudo dpkg -i libacp\_0.2.0-rc.3\_amd64.deb 
```
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b62cce02c.png)


* 修改RTE的配置文件，ComponentManger模块下加入sf1011\_sysfile
```shell
sudo vim /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b659d5246.png)

```shell
[ComponentManager]
Component.0=CmpCanBusUtils
Component.1=CmpLedManager
Component.2=CmpSinsegyeLibs
Component.3=retainDeamon
Component.4=SE4100&
Component.5=sf1011\_sysfile 
```
* 重启RTE服务，使新加入的sf1011\_sysfile被调用并确保异步文件ACP服务端组件正常运行
```shell
sudo systemctl restart sinsegyerte.service
sudo systemctl start asyncfile-service.service
sudo systemctl status asyncfile-service.service 
```

**2、IDE侧部署SF1011\_SysFile的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“ ；
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b898843fa.png)

* 弹出的对话窗中点击”安装“ -- 选中SysFileLib.library -- 点击“打开”；
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b8a186a7e.png)


* 工程中双击“库管理器”  -- “添加库”  --点击杂项 --双击“SysFileLib” ，加载库完成
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b8a793899.png)

**更新安装**

**1、升级异步文件的ACP客户端、服务端**

* 上传升级版deb包到工智机Linux环境的/home/sinsegye目录下，上传方法参考附录；

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）
```shell
sudo dpkg -i cmpsysfile\_0.0.1-rc.3\_amd64.deb&#xA;sudo dpkg -i asyncfile-service\_0.0.3\_amd64.deb 
```
* 重启RTE服务，使新升级的SF1011\_SysFile被调用
```shell
sudo systemctl restart sinsegyerte.service 
```

**2、升级IDE侧SF1011\_SysFile的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“ ；

* 弹出的对话窗中点击”安装“ -- 选中SysFileLib.library -- 点击“打开”；

* 工程中双击“库管理器”  -- “添加库”  --点击杂项 --双击“SysFileLib” ，加载库完成；

 **卸载过程**

**1、卸载异步文件的ACP客户端、服务端**

* 工智机上执行命令卸载
```shell
sudo dpkg -r cmpsysfile\_0.0.1-rc.3\_amd64.deb&#xA;sudo dpkg -r asyncfile-service\_0.0.3\_amd64.deb 
```
* 修改RTE的配置文件，ComponentManger模块下去掉sf1011\_sysfile
```shell
sudo vim /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg 
```
* 重启RTE服务
```shell
 sudo systemctl restart sinsegyerte.service
 ```
**2、卸载IDE侧SF1011\_SysFile的library**

* MetaFacture界面点击“工具” -- “库存储”&#x20;

* 对话框中选中安装的SysFileLib库，点击“卸载”

---
### 快速启动

**一、本例软、硬件配置**

| 硬件：       | 软件：                                  |
| --------- | ------------------------------------ |
| 1.SX20    | 1.MetaFacutre V1.0.6.3               |
| 2.Win11PC | 2. Sinsegye.Ide.DeviceManager0.0.1.9 |

**二、本例实验操作步骤**

1.实验要求

a.工智机成功安装相关组件

b.MetaFacture成功安装库文件SysFileLib.library

可以参考产品组件中的SysFileLib.project项目来进行本次实验

2.实验内容

**DirOpen**

打开一个目录，返回的句柄后续使用的时候都需要用到，如果需要获得目录内的条目，需要调用DirList，一个一个获得
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b967efe45.png)

**DirClose**

关闭一个目录
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9751319e.png)

**DirList**

读取目录条目，每次读取一条，读取的内容存储在结构体中

设置的机制是每次读取只会读取到一个目录信息（如果需要读取到所有的就得遍历）
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b98cb6441.png)

**DirCreate**

创建一个子目录
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9acb190f.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9b1e1aab.png)

 **DirCopy**

拷贝目录，可以通过参数指定是否拷贝子目录或者是否覆盖

**xRecursive (递归复制)**

* **TRUE**: 复制所有子目录及其内容

* **FALSE**: 不复制子目录

**xOverWrite (覆盖文件)**

* **TRUE**: 会覆盖已存在的文件

* **FALSE**: 保留已存在的文件不变

xRecursive=false xOverWrite=false
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9c344529.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9cbd8e2f.png)

![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9d578e6d.png)

xRecursive=true xOverWrite=false
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9f4611f9.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801b9fbd244d.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba0771b76.png)

xRecursive=true xOverWrite=true
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba2de026c.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba345d29c.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba3cbadba.png)

**DirRename**

重命名一个目录（不建议用此功能移动文件，可以使用Rename）
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba4ea697c.png)

![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba5678507.png)

 **DirRemove**

删除一个目录（可能有文件已经被Open打开）
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba666d4c1.png)

目录中有内容且不选择xRecursive=true就会提示错误NOT\_EMPTY
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba738efec.png)

**FileOpen**

打开一个文件，生成一个句柄，可以用于Read、Write、Close（xExclusive参数codesys不支持）

打开后返回的句柄数字很大，但结果还是正常的

MREADPLUS模式下关闭才会保留文本中原有的数据，而默认的MODE会覆盖导致数据为空
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba7fe1914.png)

**FileClose**

关闭文件句柄
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801ba90e71b5.png)

**FileRead**

读取数据到buffer中
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801baa21cccb.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801baa9d92fe.png)

**FileWrite**

将buffer写入文件中

打开文件（模式一定要选mreadplus，否则无法写入，会报错）
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bab77e3c2.png)

写入
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bac3c1b3a.png)

关闭
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bacb64fb4.png)

![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bad23e965.png)

成功写入

**FileCopy**

拷贝文件，如果不存在则创建，存在根据参数可以选择覆盖

如果文件已存在并且不选择覆盖，那么会返回对应的error code；如果文件已存在并且选择覆盖，那么就会对文件进行覆盖的操作
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bae2c640b.png)

已存在报错
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801baebf3766.png)

成功
 **FileDelete**

删除文件，如果Open也会被删除
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801baf8c5cdf.png)
 **FileRename**

重命名文件，也可以用于移动文件，不能用于移动目录
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb03bfb75.png)
 **FileSetPos**

移动当前打开文件的读写位置
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb10912e6.png)

在打开文件以后设置POS
 **FileGetPos**

读取当前打开文件的读写位置
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb1f5db13.png)

基于上述的SETPOS以后再次GET获取到一致的POS
**FileEOF**

用于判断当前读写位置是否已经到文件末尾
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb4dc0454.png)


只有在调用完FileRead功能块以后再次调用该接口才会返回EOF的状态，需要配合FileRead一起使用

**FileFlush**

强制将缓冲区内的数据写入到磁盘中
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb58a0b74.png)


默认情况下write以后数据并没有直接进入（还处于缓冲区中）使用该功能块后不需要close也就立马看到写入的数据
**FileGetAttribute**

获得当前打开文件的文件属性，文件属性的定义位于枚举变量ATTRIB
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb77a8dd7.png)

 **FileGetSize**

获取文件名指向文件的文件大小
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb812569d.png)

 **FileGetTime**

获取文件名指向文件的最新修改日期

备注：默认获取的就是UTC时间，如果需要本地时间则需要进行手动做时间的转换
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb8d5a50d.png)


证明：使用codesys的CAA File功能测试结果是一致的
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bb97a2338.png)
![](https://resource.helplook.net/docker_production/3648ne/article/FhGpF0X5/6801bba05ad53.png)